<?php

// No direct access
defined( '_JEXEC' ) or die;

/**
 *@author Sivers
 */
class CatalogModelProds extends JModelList
{
	public function __construct($config = array()){   
		$config['filter_fields'] = array(
            'score',
		);
		parent::__construct($config);
	}

	protected function populateState($ordering = null, $direction = null){
		global $app, $catalogGetFilter;
		$input = $app->input;
		$ses = $app->getSession();
        
		$ord = false;
		$dir = false;

        $ordby = $input->getCmd('ordby', '');
        if(in_array($ordby, array('dscore'))){
            $dir = substr($ordby, 0, 1) == 'd' ? 'DESC' : 'ASC';
            $ord = substr($ordby, 1);
        }
        //~ if(CFG_ALLOW && !empty($_POST)) exit(print_r(array($_POST, $ordby, $ord),1));
        
		if($ord){
			$ses->set('ord', $ord);
			$ses->set('dir', $dir);
            exit;
            $uri = func::getLink(0, 'uri');
            $get = $_GET;
            foreach($get as $key => $val) if(empty($val)) unset($get[$key]);
            if(!empty($get)) $uri .= '?'.http_build_query($get);
            if(!empty($sort)) $app->redirect($uri);
		}else{
			if($ses->has('ord')) $ord = $ses->get('ord');
			if($ses->has('dir')) $dir = $ses->get('dir');
		}
        
		if(!in_array($dir, array('asc', 'desc', 'ASC', 'DESC'))) $dir = 'ASC';
		if(!in_array($ord, $this->filter_fields)){
            $ord = 'id';
            $dir = 'ASC';
        }
        
		parent::populateState($ord, $dir);

        $this->setState('item.id', $input->getString('id', ''));
        $this->setState('item.vs', $input->getString('vs', ''));
        //~ $this->setState('item.tab', $tab = $input->getCmd('tab', ''));
        //~ if(!empty($tab)) $this->setState('item.'.$tab, $input->getCmd($tab, ''));
        
        $this->setState('list.q', $input->getString('q', ''));
		$this->setState('list.page', $input->getInt('page', 1));
		$this->setState('list.start', $input->getInt('limitstart'));
		$this->setState('list.limit', CFG_LIMIT);
		$this->setState('list.ordering', $ord);
		$this->setState('list.direction', $dir);
    }

    protected function getListQuery(){
        global $app;
        
		$id = $this->state->get('item.id');
		$vs = $this->state->get('item.vs');
		$q = $this->state->get('list.q');
		$ord = $this->state->get('list.ordering');
		$dir = $this->state->get('list.direction');

        $db = $this->getDbo();
        $query = $db->getQuery(true);
        //~ $query->select("*, MIN(`price`) AS `pmin`, MAX(`price`) AS `pmax`");
        $query->select("*, e.id");
        $query->from(DB_CPU." AS `e`");
        $query->where("e.`id` > 0");
        if($vs && $id) $query->where("(e.`id` = ".intval($vs)." OR e.`id` = ".intval($id).")");
        elseif($id) $query->where("e.`id` = ".intval($id)."");
        if(!empty($q)){
            $qlen = mb_strlen($q);
            if($qlen >= 3){
                // Полнотекстовый поиск
                $q = str_replace(array('!', '"', ';', ':', '(', ')', '.', ',', '?', '-', '+'), ' ', $q);
                $segs = explode(' ', $q);
                foreach($segs as $s => $seg){
                    if(mb_strlen($seg) < 3){
                        unset($segs[$s]);
                    }
                }
                //~ $q = '+'.implode('+', $segs);
                $q = implode(' ', $segs);

                //~ $fulltxt = "MATCH (`region`, `area`, `city`, `street`) AGAINST (".$db->quote($q)." IN NATURAL LANGUAGE MODE)";
                $fulltxt = "MATCH (e.`name`) AGAINST (".$db->quote($q)." IN BOOLEAN MODE)";
                $query->select("{$fulltxt} AS `ftrel`");
                $query->order("`ftrel` DESC");
                $query->where("{$fulltxt} > 0");
            }
        }
        if(!$id && empty($q)) $query->where("FALSE");
        $query->order($ord.' '.$dir);

        //~ $this->setState('list.query', trim(strip_tags($query->dump())));
        //~ if(CFG_ALLOW) echo $query->dump();
        //~ if(CFG_ALLOW) exit($query->dump());
        return $query;
    }

    /*public function _getList($query, $limitstart = 0, $limit = 0){
        $start = $this->state->get('list.start');
        if($start != $limitstart) func::err();
        //~ if(CFG_ALLOW) func::prn($query);
        $list = parent::_getList($query, $limitstart, $limit);
        //~ $list = array();
        //~ func::prn($query);
        return $list;
    }*/

    public function getItems($items = false, $recourse = false){
        $db = JFactory::getDbo();
        //~ $Itemid = $this->state->get('area.Itemid');
        //~ $type = $this->state->get('area.type');
        //~ $page = $this->state->get('list.page');
        //~ $ord = $this->state->get('list.ordering');
        //~ $q = $this->state->get('data.q');

        if(empty($items)) $items = parent::getItems();

        $diff = array();

        if(!empty($items)){
            func::setItemExt($items, 'cpu');
        }

        $this->items = &$items;
        return $items;
    }
    
    public function getAction(){
        $id = $this->state->get('item.id');
        $action = $this->state->get('item.action');
        $val = func::setAction($action, $id, 'e');
        exit(json_encode($val));
    }

}
