<?php
defined( '_JEXEC' ) or die; // No direct access

class CatalogRouter extends JComponentRouterBase
{
	/**
	 * Build the route for the com_offers component
	 *
	 * @param   array  &$query  An array of URL arguments
	 *
	 * @return  array  The URL arguments to use to assemble the subsequent URL.
	 *
	 * @since   3.3
	 */
	public function build(&$query)
	{
        //~ func::prn($query);
		$segments = array();
        $Itemid = isset($query['Itemid']) ? intval($query['Itemid']) : 0;
        //~ if(CFG_ALLOW) func::prn($query);
        //~ if(CFG_ALLOW) func::prn($Itemid);
        
        switch($Itemid){
            //~ case MI_COMPARE:
            //~ case MI_PROMO:
            //~ case MI_PROD:
            //~ case MI_ITEM:
            case MI_GAME:
            case MI_CPU:
            case MI_GPU:
                if(!empty($query['id'])){
                    // Товар
                    if(!empty($query['vs'])){
                        $segments[] = func::translit($query['id']).'-vs-'.func::translit($query['vs']);
                        unset($query['id']);
                        unset($query['vs']);
                    }else{
                        $segments[] = func::translit($query['id']);
                        unset($query['id']);
                    }
                }else{
                    /*
                    if(!empty($query['loc'])){
                        $locs = func::getLocs();
                        if(isset($locs[$query['loc']]) && $query['loc'] != DEF_LOC) $segments[] = $query['loc'];
                        unset($query['loc']);
                    }
                    */
                    if(!empty($query['cid'])){
                        // Категория
                        $segments[] = $query['cid'].'-'.$query['alias'];
                        unset($query['alias']);
                        unset($query['cid']);
                    }
                    if(isset($query['start'])){
                        $page = ceil(intval($query['start'])/CFG_LIMIT)+1;
                        if($page > 1) $segments[] = 'p'.$page;
                        unset($query['start']);
                    }elseif(isset($query['limitstart'])){
                        $page = ceil(intval($query['limitstart'])/CFG_LIMIT)+1;
                        if($page > 1) $segments[] = 'p'.$page;
                        unset($query['limitstart']);
                    }
                }
            break;
            //~ case MI_PANL:
            //~ case MI_PANL_CATS:
            //~ case MI_SUGGEST:
            case 1:
            break;
            default:
                if (isset($query['task'])){
                    $segments[] = $query['task'];
                    unset($query['task']);
                }
                if (isset($query['action'])){
                    $segments[] = $query['action'];
                    unset($query['action']);
                }
            break;
        }
        
		$segments = str_replace(':', '-', $segments);
        
        if(!isset($query['format'])) $segments[] = '/';

        if(isset($query['page'])) unset($query['page']);
        if(isset($query['view'])) unset($query['view']);
        if(isset($query['type'])) unset($query['type']);
        if(isset($query['format'])) unset($query['format']);
        if(isset($query['layout'])) unset($query['layout']);
        
        //~ func::prn($query);
        //~ if($Itemid == MI_COMPARE) func::prn($segments);
        
		return $segments;
	}

	/**
	 * Parse the segments of a URL.
	 *
	 * @param   array  &$segments  The segments of the URL to parse.
	 *
	 * @return  array  The URL attributes to be used by the application.
	 *
	 * @since   3.3
	 */
	public function parse(&$segments)
	{
        global $app;
        //~ $pathway = $app->getPathway();
        
        $vars = array();
        $count = count($segments);
        
        $menu = JMenu::getInstance('site');
        $menuAct = $menu->getActive();
        $menuId = empty($menuAct) ? 0 : $menuAct->id;
//~ func::prn($segments);func::prn($menuId);exit('---');
        if(isset($menuAct->query) && is_array($menuAct->query)) $vars = $menuAct->query;
        $vars['Itemid'] = $menuId;
        //~ $locs = func::getLocs();
        
        list($uri) = explode('?', $_SERVER['REQUEST_URI']);
        
		if($count){
            // Присутствует пагинация
            if(strpos($segments[$count-1], 'p') !== false && is_numeric($page = str_replace('p', '', $segments[$count-1])) && intval($page) > 0){
                $vars['page'] = intval($page);
                $vars['start'] = (intval($page)-1)*CFG_LIMIT;
                $vars['limitstart'] = $vars['start'];
                unset($segments[$count-1]);
                $count--;
            }

            // Присутствует город в ссылке на каталог? (надо записать его в куку)
            /*
            $vars['loc'] = $app->input->cookie->get('lid', DEF_LOC);
            if($menuId == MI_PROD){
                if($count && isset($locs[$segments[0]])){
                    $vars['loc'] = array_shift($segments);
                    $count--;
                }else{
                    $vars['loc'] = DEF_LOC;
                }
                setcookie('lid', $vars['loc'], time()+60*60*24*30, '/');
            }
            */

            if($count) switch($menuId){
                //~ case MI_COMPARE:
                //~ case MI_PROD:
                case 1:
                    $parts = explode('-', $segments[$count-1], 2);
                    if(count($parts) == 2 && is_numeric($parts[0])){
                        unset($segments[$count-1]);
                        $count--;
                        //~ $type = substr($uri, -1, 1) == '/' ? 'cid' : 'pid';
                        $type = 'cid';
                        $vars[$type] = $parts[0];
                        $vars['alias'] = $parts[1];
                    }
                break;
                case MI_GAME:
                case MI_CPU:
                case MI_GPU:
                    $parts = explode('-', $segments[0], 2);
                    if(count($parts) == 2 && is_numeric($parts[0])){
                        $id = array_shift($segments);
                        if(strpos($id, '-vs-') !== false){
                            list($id, $vs) = explode('-vs-', $id, 2);
                            $vars['vs'] = $vs;
                        }else{
                        }
                        $vars['id'] = $id;
                    }
                    $seoConst = 'SEO_'.mb_strtoupper($menuAct->alias).'_'.$seoConst;
                break;
                //~ case MI_CART:
                case 1:
                    if($count){
                        $vars['action'] = array_shift($segments);
                        $count--;
                    }
                break;
                //~ case MI_HIST:
                case 1:
                    if($count){
                        $vars['id'] = array_shift($segments);
                        $count--;
                    }
                    if($count){
                        $vars['get'] = array_shift($segments);
                        $count--;
                    }
                break;
                //~ case MI_NEWS:
                //~ case MI_PROMO:
                case 1:
                    // Читаем статью по артикулу или ИДу
                    if($count){
                        $vars['id'] = array_shift($segments);
                        if(!is_numeric($vars['id'])) $vars['id'] = func::getArticlesId($vars['id']);
                        $count--;
                    }
                break;
                //~ case MI_AJAX:
                case 1:
                    if($count){
                        $vars['action'] = array_shift($segments);
                        $count--;
                    }
                break;
                //~ case MI_HOME:
                case 1:
                
                break;
                default:
                    if($count == 1){
                        //~ $vars[(is_numeric($segments[0]) ? 'id' : 'tab')] = array_shift($segments);
                        //~ $count--;
                    }
                break;
            }
        }

//~ if(CFG_ALLOW){ func::prn($segments); func::prn($vars); exit; }

        if(!CFG_CONSOLE && !empty($segments)) func::err();
        
        //~ if(!empty($vars['page'])) $pathway->addItem('Страница '.$vars['page']);
//~ func::prn($vars);exit('g');
        return $vars;
	}
    
    //~ public function preprocess($query){
        //~ return $query;
    //~ }
}

