<?php

// No direct access
defined( '_JEXEC' ) or die;

/**
 * Class Module Helper
 * @author Sivers
 */
class modSwformHelper
{

	/**
	 * getData method
	 * @param $params
	 * @return array
	 */
	static function getData($params)
	{
		$data = array();
        $action = array();
        $action['Itemid'] = $params->get('action', 0);
        if($params->get('ajax', false)){
            $action['option'] = 'com_ajax';
            $action['module'] = 'swform';
            $action['id'] = $params->get('module_id', 0);
            $data['action'] = JRoute::_('index.php?'.http_build_query($action));
        }else{
            $data['action'] = explode('?', JRoute::_('index.php?Itemid='.$action['Itemid']))[0];
        }
		return $data;
	}

	static function getForm($params)
	{
        global $app;
		$xml = __DIR__ . '/xml/'.$params->get('xml', 'none');
        if(!file_exists($xml)) return false;
        $name = basename($xml, '.xml');
        $form = JForm::getInstance($name, $xml);
        $form->setField(new SimpleXMLElement('<field name="form" type="hidden" default="'.htmlspecialchars($name).'" />'));
        if(!empty($_POST['form']) && $_POST['form'] == $name){
            $form->bind($_POST);
            if($form->validate($_POST)){
                $data = $form->getData()->toArray();

                $honey = trim($params->get('honey', ''));
                $honeyOk = true;
                if(!empty($honey)){
                    $fhons = explode(',', $honey);
                    foreach($fhons as $fhon){
                        $fhon = trim($fhon);
                        if(!empty($data[$fhon])) $honeyOk = false;
                    }
                }

                if($honeyOk) $app->triggerEvent('onAfterFormPost', array($form, $data));
                $succ = $params->get('success', '');
                if(!empty($succ)) $app->enqueueMessage($succ);
                $action = '/';
                $actid = $params->get('action', '');
                if(!empty($actid)) $action = JRoute::_('index.php?Itemid='.$actid);
                $app->redirect($action, 303);
            }else{
                $errors = $form->getErrors();
                foreach($errors as $error) $app->enqueueMessage($error->getMessage(), 'error');
            }
        }
		return $form;
	}

	static function getAjax()
	{
        global $app;
        $name = $app->input->getCmd('form', '');
        if(empty($name)) return false;
        $xml = $name.'.xml';
        if(!file_exists(__DIR__ .'/xml/'.$xml)) return false;
        $params = new JRegistry();
        $params->set('xml', $xml);
        $form = self::getForm($params);
        $mess = $app->getMessageQueue(true);
        $result = array();
        $result['ok'] = empty($mess);
        if(!$result['ok']) $result['err'] = $mess;
        header('Content-type: application/json; charset=UTF-8');
        exit(json_encode($result));
	}

}
