<?php
// No direct access
defined( '_JEXEC' ) or die;

/**
 *
 * @package     Joomla.Plugin
 * @subpackage  System.Swform
 * @since       2.5+
 * @author		Sivers
 */
class plgSystemSwform extends JPlugin
{
	/**
	 * Class Constructor
	 * @param object $subject
	 * @param array $config
	 */

    public $app;
     
	public function __construct( & $subject, $config )
	{
		parent::__construct( $subject, $config );
		$this->loadLanguage();
        $this->app = JFactory::getApplication();
	}

    public function onAfterGetMenuTypeOptions(&$list, $model){
        // Добавляем тип меню для компонента Ajax
        if($this->params->get('ajaxmenu', 0)){
            if(!isset($list['com_ajax'])) $list['com_ajax'] = array();
            $option = new JObject;
            $option->title = "COM_AJAX";
            $option->description = "COM_AJAX_XML_DESCRIPTION";
            $option->request = array('option' => "com_ajax", 'module' => "swform", 'format' => "raw");
            $list['com_ajax'][] = $option;
            $model->addReverseLookupUrl($option);
            // Подключаем языки
            $lang = JFactory::getLanguage();
            $componentLanguageFolder = JPATH_ADMINISTRATOR . '/components/' . $option->request['option'];
            $lang->load($option->request['option'] . '.sys', JPATH_ADMINISTRATOR, null, false, true) || $lang->load($option->request['option'] . '.sys', $componentLanguageFolder, null, false, true);
        }
    }

    private function getEmails(){
        if(empty($this->emails)) $this->emails = JFactory::getDbo()->setQuery("SELECT `email`, `name` FROM `#__users` WHERE `block` = 0 AND `sendEmail` = 1")->loadObjectList();
        return $this->emails;
    }

    public function onAfterFormPost($form, $data){
        switch($form->getName()):
            case 'feedback':
            default:
                $fromMail = $this->app->getCfg('mailfrom');
                $fromName = $this->app->getCfg('fromname');

                // Письмо админам
                $admins = $this->getEmails();
                $aSubj = 'Получена форма `'.$form->getName().'` с сайта '.JUri::root();
                $aBody = '<pre>'.print_r($data,1).'</pre>';

                file_put_contents(__FILE__ .'.body.log', print_r($aBody,1));
                
                $ftpl = __DIR__ .'/tpl/'.$form->getName().'.php';
                if(file_exists($ftpl)) include($ftpl);
                
                //~ file_put_contents(__FILE__ .'.log', print_r($admins,1).PHP_EOL.$aBody);
                foreach($admins as $admin) JFactory::getMailer()->sendMail($fromMail, $fromName, $admin->email, $aSubj, $aBody, $mode = true);
                //~ exit('OK');
            break;
        endswitch;
    }
}
