<?php
// No direct access
defined( '_JEXEC' ) or die;

use Joomla\CMS\Factory;

/**
 *
 * @package     Joomla.Plugin
 * @subpackage  System.Swform
 * @since       2.5+
 * @author		Sivers
 */
class plgSystemSwform extends JPlugin
{
	/**
	 * Class Constructor
	 * @param object $subject
	 * @param array $config
	 */

    public $app;
    public $emails;
     
	public function __construct( & $subject, $config )
	{
		parent::__construct( $subject, $config );
		$this->loadLanguage();
        $this->app = Factory::getApplication();
	}

    public function onAfterGetMenuTypeOptions(&$list, $model){
        // Добавляем тип меню для компонента Ajax
        if($this->params->get('ajaxmenu', 0)){
            if(!isset($list['com_ajax'])) $list['com_ajax'] = array();
            $option = new JObject;
            $option->title = "COM_AJAX";
            $option->description = "COM_AJAX_XML_DESCRIPTION";
            $option->request = array('option' => "com_ajax", 'module' => "swform", 'format' => "raw");
            $list['com_ajax'][] = $option;
            $model->addReverseLookupUrl($option);
            // Подключаем языки
            $lang = JFactory::getLanguage();
            $componentLanguageFolder = JPATH_ADMINISTRATOR . '/components/' . $option->request['option'];
            $lang->load($option->request['option'] . '.sys', JPATH_ADMINISTRATOR, null, false, true) || $lang->load($option->request['option'] . '.sys', $componentLanguageFolder, null, false, true);
        }
    }

    private function getEmails(){
        if(empty($this->emails)) $this->emails = JFactory::getDbo()->setQuery("SELECT `email`, `name` FROM `#__users` WHERE `block` = 0 AND `sendEmail` = 1")->loadObjectList();
        return $this->emails;
    }

    public function onAfterFormPost($form, $data, $params){
        $mid = $params->get('module_id', 0);
        $hidecss = '<style> #'.$form->getName().$mid.' .form-fields { display: none; } </style>';
        
        switch($form->getName()):
            case 'subscribe':
                if(!empty($data['email'])){
                    $db = Factory::getDbo();
                    $email = mb_strtolower($data['email']);
                    $item = $db->setQuery("SELECT * FROM `#__catalog_subscribe` WHERE `email` = ".$db->quote($email))->loadObject();
                    if(!empty($item)){
                        if($item->active) exit($hidecss.'<div class="alert alert-primary">Вы уже подписаны на новости.</div>');

                        $unsub = $db->setQuery("SELECT * FROM `#__catalog_unsubscribe` WHERE `email` = ".$db->quote($email))->loadObject();
                        if(!empty($unsub)) exit('<div class="alert alert-danger">Ваша почта была удалена из всех подписок.</div>');

                        $item->active = 1;
                        $item->sdate = date('Y-m-d H:i:s');
                        $item->stime = time();
                        $db->updateObject("#__catalog_subscribe", $item, 'id');
                        exit($hidecss.'<div class="alert alert-success">Ваша подписка восстановлена.</div>');
                    }else{
                        $item = new stdClass;
                        $item->id = null;
                        $item->name = $data['name'];
                        $item->email = $email;
                        $item->sdate = date('Y-m-d H:i:s');
                        $item->stime = time();
                        $item->active = 1;
                        $db->insertObject("#__catalog_subscribe", $item, 'id');
                        return true;
                    }
                }
            break;
            case 'feedback':
            default:
                $fromMail = $this->app->getCfg('mailfrom');
                $fromName = $this->app->getCfg('fromname');

                // Письмо админам
                $admins = $this->getEmails();
                $aSubj = 'Получена форма `'.$form->getName().'` с сайта '.JUri::root();
                $aBody = '<pre>'.print_r($data,1).'</pre>';

                file_put_contents(__FILE__ .'.body.log', print_r($aBody,1));
                
                $ftpl = __DIR__ .'/tpl/'.$form->getName().'.php';
                if(file_exists($ftpl)) include($ftpl);
                
                //~ file_put_contents(__FILE__ .'.log', print_r($admins,1).PHP_EOL.$aBody);
                foreach($admins as $admin) JFactory::getMailer()->sendMail($fromMail, $fromName, $admin->email, $aSubj, $aBody, $mode = true);
                //~ exit('OK');
            break;
        endswitch;
    }
}
