if(window.addEventListener){
    window.addEventListener('load', onLoadPage, false);
}else{
    if(window.attachEvent){
        window.attachEvent('onload', onLoadPage);
    }else{
        window.onload = onLoadPage;
    }
}

function onLoadPage(){
    onInitForms();
}

function onInitForms(){
    document.querySelectorAll('form.needs-validation').forEach(form => {
        form.addEventListener('submit', event => {
            event.preventDefault()
            event.stopPropagation()
            form.classList.add('was-validated');

            if(form.checkValidity()){
                let data = new FormData(form);
                form.querySelectorAll('.form-fields').forEach(ff => { ff.setAttribute('disabled', 'disabled'); });
                fetch('', {  
                    method: 'post',  
                    body: data
                }).then(function(resp){
                    form.querySelectorAll('.form-fields').forEach(ff => { ff.removeAttribute('disabled'); });
                    if(resp.status == 200){
                        resp.text().then(function(resp){  
                            form.querySelectorAll('.form-messages').forEach(fm => {
                                fm.innerHTML = resp;
                            });
                        });
                    }
                }).catch(err => alert(err));
            }
        }, false);
    });
}
