<?php

// No direct access
defined( '_JEXEC' ) or die;

use Joomla\CMS\Factory;

/**
 * Class Module Helper
 * @author Sivers
 */
class modSwformHelper
{

	/**
	 * getData method
	 * @param $params
	 * @return array
	 */
	static function getData($params)
	{
		$data = array();
        $action = array();
        $action['Itemid'] = $params->get('action', 0);
        if($params->get('ajax', false)){
            $action['option'] = 'com_ajax';
            $action['module'] = 'swform';
            $action['id'] = $params->get('module_id', 0);
            $data['action'] = JRoute::_('index.php?'.http_build_query($action));
        }else{
            $data['action'] = explode('?', JRoute::_('index.php?Itemid='.$action['Itemid']))[0];
        }
		return $data;
	}

	static function getForm($params, $ajax = null)
	{
        $app = Factory::getApplication();
		$xml = __DIR__ . '/xml/'.$params->get('xml', 'none');
        if(!file_exists($xml)) return false;
        $name = basename($xml, '.xml');
        $honey = trim($params->get('honey', ''));
        $succ = $params->get('success', '');
        $actid = $params->get('action', '');
        if(is_null($ajax)) $ajax = intval($params->get('ajax', 0));
        $mid = $params->get('module_id', 0);

        $form = JForm::getInstance($name, $xml);
        $form->setField(new SimpleXMLElement('<field name="form" type="hidden" default="'.htmlspecialchars($name).'" />'));

        if(empty($honey)){
            $honey = [];
            $fields = $form->getFieldset();
            foreach($fields as $fname => $field){
                if(strpos($field->class, 'honey') !== false) $honey[] = $fname;
            }
            $honey = implode(',', $honey);
        }
        
        if(!empty($_POST['form']) && $_POST['form'] == $name){
            $form->bind($_POST);
            if($form->validate($_POST)){
                $data = $form->getData()->toArray();
                $honeyOk = true;
                if(!empty($honey)){
                    $fhons = explode(',', $honey);
                    foreach($fhons as $fhon){
                        $fhon = trim($fhon);
                        if(!empty($data[$fhon])) $honeyOk = false;
                    }
                }

                if($honeyOk) $app->triggerEvent('onAfterFormPost', array($form, $data));
                $msgs = [];
                $msgs[] = '<style> #'.$name.$mid.' .form-fields { display: none; } </style>';
                if(!empty($succ)) $msgs[] = '<div class="alert alert-success">'.$succ.'</div>';
                if($ajax) exit(implode(PHP_EOL, $msgs));
                if(!empty($succ)) $app->enqueueMessage($succ);
                $action = '/';
                if(!empty($actid)) $action = JRoute::_('index.php?Itemid='.$actid);
                $app->redirect($action, 303);
            }else{
                $errors = $form->getErrors();
                $msgs = [];
                foreach($errors as $error){
                    $msg = $error->getMessage();
                    if($ajax){
                        $msgs[] = '<div class="alert alert-danger">'.$msg.'</div>';
                    }else{
                        $app->enqueueMessage($msg, 'error');
                    }
                }
                if($ajax) exit(implode(PHP_EOL, $msgs));
            }
        }
		return $form;
	}

	static function getAjax()
	{
        global $app;
        $name = $app->input->getCmd('form', '');
        if(empty($name)) return false;
        $xml = $name.'.xml';
        if(!file_exists(__DIR__ .'/xml/'.$xml)) return false;
        $params = new JRegistry();
        $params->set('xml', $xml);
        $form = self::getForm($params, true);
        $mess = $app->getMessageQueue(true);
        $result = array();
        $result['ok'] = empty($mess);
        if(!$result['ok']) $result['err'] = $mess;
        header('Content-type: application/json; charset=UTF-8');
        exit(json_encode($result));
	}

}
