<?php   
// No direct access
defined( '_JEXEC' ) or die;

use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;

/**
 *
 * @package     Joomla.Plugin
 * @subpackage  System.SwSeo
 * @since       4.0+
 * @author		Sivers
 */
class plgContentSwcont extends CMSPlugin
{
    protected $app;

	public function __construct(&$subject, $config){
		parent::__construct($subject, $config);
        $this->loadLanguage();
		$this->app = Factory::getApplication();
    }
    
    public function onAfterInitialise(){
        if($this->app->isClient('site')){
        }
    }
    
    public function onContentPrepare($context, $article, $params, $limitstart){
        if($this->app->isClient('site')){
            switch($context){
                case 'com_content.article':
                    $mid = $this->app->getMenu()->getActive()->id;
                    $cats = $this->params->get('category', false);
                    if(empty($cats)) $cats = array();
                    $mitems = $this->params->get('menuitem', false);
                    if(empty($mitems)) $mitems = array();
                    if(in_array($article->catid, $cats) || in_array($mid, $mitems)){
                        $article->text = $this->makeContent($article->text);
                        //~ $article->fulltext = $this->makeContent($article->fulltext);
                    }                    
                break;
            }
        }
    }

    private function makeContent($text){
        if(preg_match_all('|<(h(\d++))([^>]*)>(.+)</h\d+>|isU', $text, $pregs, PREG_SET_ORDER)){
            //~ file_put_contents(__FILE__ .'.pregs.log', print_r($pregs,1));
            $minLevel = min(array_column($pregs,2));
            $level = '';
            $block = '<div class="nav-article-page py-3 px-4 rounded mb-4"><div class="fs-5 medium mb-2">Содержание</div>{pos}</div>';
            foreach($pregs as $preg){
                // Если имеем на уровень глубже
                if($level < $preg[2]){
                    if(!$level) $pos = '<ul class="ps-3">{pos'.$preg[2].'}</ul>';
                    else $pos = '<ul>{pos'.$preg[2].'}</ul>';
                    $block = str_replace('{pos'.$level.'}', $pos.'{pos'.$level.'}', $block);
                    $level = $preg[2];
                }elseif($level > $preg[2]){
                    $block = preg_replace('|\{pos\d+\}|isU', '', $block);
                    $level = $preg[2];
                    if(strpos($block, '{pos'.$level.'}') === false) $block = str_replace('{pos}', '<ul class="ps-3">{pos'.$level.'}</ul>{pos}', $block);
                }
                if(strpos($preg[0], ' id=') !== false && preg_match('|\sid="([^"]+)"|isU', $preg[0], $pr)){
                    $id = $pr[1];
                }else{
                    $preg4 = trim(strip_tags($preg[4]));
                    $id = class_exists('Ru_RULocalise') ? Ru_RULocalise::transliterate($preg4) : $preg4;
                    $id = str_replace(' ', '-', $id);
                    $preg0 = str_replace('<'.$preg[1], '<'.$preg[1].' id="'.$id.'"', $preg[0]);
                    $text = str_replace($preg[0], $preg0, $text);
                }
                $pos = '<li><a href="#'.$id.'">'.$preg[4].'</a></li>';
                $block = str_replace('{pos'.$level.'}', $pos.'{pos'.$level.'}', $block);
            }
            $block = preg_replace('|\{pos\d*\}|isU', '', $block);
            //~ file_put_contents(__FILE__ .'.block.log', print_r($block,1));
            $text = $block.$text;
        }
        return $text;
    }
}
