<?php   
// No direct access
\defined( '_JEXEC' ) or die;

use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;

/**
* author: sivers;
* site: saweb.ru
* email: info@saweb.ru
*/

class plgSystemSwcurrate extends CMSPlugin
{

    protected $app;

	public function __construct(&$subject, $config){
		parent::__construct($subject, $config);
		$this->app = Factory::getApplication();
    }
    
    public function onAfterInitialise(){
        if($this->app->isClient('site')){
            $frequency = (int)$this->params->get('frequency');
            $const_list = $this->params->get('const_list');
            $const_val = $this->params->get('const_val');
            $code_src = $this->params->get('code_src');
            $code_dst = $this->params->get('code_dst');
            $round = (int)$this->params->get('round');
            
            $cache = Factory::getCache(__CLASS__);
            $cache->setCaching(1);
            $cache->setLifeTime($frequency);
            $list = $cache->get(array(__CLASS__, 'getRatesCBR'));

            if(!defined($const_list)) define($const_list, $list);
            $src = isset($list[$code_src]) ? $list[$code_src]['nominal'] * $list[$code_src]['value'] : 1;
            $dst = isset($list[$code_dst]) ? $list[$code_dst]['nominal'] * $list[$code_dst]['value'] : 1;
            if($dst == 0) $dst = 1;
            $val = $src / $dst;
            $val = round($val, $round);
            
            if(!defined($const_val)) define($const_val, $val);
        }
    }

    static function getRatesCBR(){
        $flast = __DIR__ .'/cbr.xml';
        $url = 'https://cbr.ru/scripts/XML_daily.asp';
        $timeout = 1;
        $ctx = stream_context_create(array('http' => array('timeout' => $timeout), 'https' => array('timeout' => $timeout)));
        try {
            $cont = file_get_contents($url, false, $ctx);
        } catch(\Exception $e){
            return false;
        }
        $xml = simplexml_load_string($cont);
        if(empty($xml)){
            if(file_exists($flast)) $xml = simplexml_load_string(file_get_contents($flast));
            else return false;
        }else{
            file_put_contents($flast, $cont);
        }
        $result = array();
        $xPath = "/ValCurs/Valute";
        $allCurrencies = $xml->xpath($xPath);
        foreach($allCurrencies as $currency){
            $code = trim($currency->CharCode);
            $name = trim($currency->Name);
            $nominal = trim($currency->Nominal);
            $value = trim($currency->Value);
            $value = str_replace(',', '.', $value);
            $value = floatval($value);
            $result[$code] = array(
                'code' => $code,
                'name' => $name,
                'nominal' => $nominal,
                'value' => $value,
            );
        }
        return $result;
    }
}
