<?php   
// No direct access
\defined( '_JEXEC' ) or die;

use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;

/**
* author: sivers;
* site: saweb.ru
* email: info@saweb.ru
*/

class plgSystemSwrouter extends CMSPlugin {

    protected $app;

	public function __construct(&$subject, $config){
		parent::__construct($subject, $config);

		$this->app = Factory::getApplication();
    }

	public function onAfterInitialise(){
        // Включается для фронта при активной настройке ЧПУ джумлы
        // Before и After опледеляет момент вызова обработчика относительно вызова собственного роутера компонента
        if($this->app->isClient('site') && $this->app->getCfg('sef', false)){
            $router = $this->app->getRouter();
            $router->attachBuildRule(array($this, 'onBeforeBuildRoute'), Joomla\CMS\Router\SiteRouter::PROCESS_BEFORE);
            $router->attachBuildRule(array($this, 'onAfterBuildRoute'), Joomla\CMS\Router\SiteRouter::PROCESS_AFTER);
            $router->attachParseRule(array($this, 'onBeforeParseRoute'), Joomla\CMS\Router\SiteRouter::PROCESS_BEFORE);
            $router->attachParseRule(array($this, 'onAfterParseRoute'), Joomla\CMS\Router\SiteRouter::PROCESS_AFTER);
        }
        return true;
    }

    public function onBeforeBuildRoute(&$siteRouter, &$uri)
    {
        
    }
    
    public function onAfterBuildRoute(&$siteRouter, &$uri)
	{
        $path = $uri->getPath();

        if((int)$this->params->get('enable_sef_pages', false)){
            $word = $this->params->get('word_sef_pages', '');
            if(strpos($word, '#') === false) $word .= '#';
            $limit = (int)$this->app->input->get('limit', $this->app->get('list_limit', 0), 'uint');
            $start = (int)$uri->getVar('start', '');
            if($start){
                $end = substr($path, -1) != '/' ? '/' : '';
                
                $path = rtrim($path, '/').'/'.str_replace('#', intval($start/$limit)+1, $word).$end;
                $uri->setPath($path);
            }
            $uri->delVar('start');
        }

		return true;
	}

    public function onBeforeParseRoute(&$siteRouter, &$uri)
    {
        $segments = explode('/', $uri->getPath());
        if(empty($segments)) return true;

        if((int)$this->params->get('enable_sef_pages', false)){
            $word = $this->params->get('word_sef_pages', '');
            if(strpos($word, '#') === false) $word .= '#';
            $last = array_pop($segments);
            if(preg_match('|^'.str_replace('#', '(\d+)', $word).'$|isU', $last, $preg) && intval($preg[1]) > 1){
                $limit = (int)$this->app->input->get('limit', $this->app->get('list_limit', 0), 'uint');
                $start = (intval($preg[1])-1)*$limit;
                $uri->setVar('start', $start);
                $uri->setPath(implode('/', $segments));
                $query = $uri->getQuery();
                if(!empty($query)) $query .= '&';
                $query .= 'start='.$start;
            }
        }

        return true;
    }

    public function onAfterParseRoute(&$siteRouter, &$uri)
    {

    }
}
