<?php   
// No direct access
defined( '_JEXEC' ) or die;

use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;

/**
 *
 * @package     Joomla.Plugin
 * @subpackage  System.SwSeo
 * @since       4.0+
 * @author		Sivers
 */
class plgContentSwseo extends CMSPlugin
{
    protected $app;

	public function __construct(&$subject, $config){
		parent::__construct($subject, $config);
        $this->loadLanguage();
		$this->app = Factory::getApplication();
    }
    
    public function onAfterInitialise(){
        if($this->app->isClient('site')){
        }
    }
    
	public function onContentPrepareForm($form, $data) {
        if (!($form instanceof Joomla\CMS\Form\Form)) {
            return false;
        }

        $name = $form->getName();
        
        switch($name){
            case 'com_content.article':
                $body = $this->app->getBody();
                file_put_contents(__FILE__ .'.body.log', $body);

                $this->app->getDocument()->addScriptDeclaration("
window.addEventListener('DOMContentLoaded', () => {
    let target = document.querySelector('#fieldset-metadata > div');
    document.querySelectorAll('#jform_attribs_article_page_title').forEach(el => {
        target.insertBefore(el.closest('.control-group'), target.firstElementChild);
    });
});
                ");
                $origLabel = $form->getFieldAttribute('article_page_title', 'label', '', 'attribs');
                $form->setFieldAttribute('article_page_title', 'label', Text::_('PLG_CONTENT_SWSEO_TITLE_LABEL'), 'attribs');
                $form->setFieldAttribute('article_page_title', 'description', $origLabel, 'attribs');
            break;
            case 'com_categories.categorycom_content':
                $this->app->getDocument()->addScriptDeclaration("
window.addEventListener('DOMContentLoaded', () => {
    let target = document.querySelector('#fieldset-metadata > div');
    document.querySelectorAll('#jform_params_category_page_title').forEach(el => {
        target.insertBefore(el.closest('.control-group'), target.firstElementChild);
    });
});
                ");
                $form->load('<?xml version="1.0" encoding="UTF-8"?><form><fields name="params"><fieldset name="basic"><field name="category_page_title" type="text" label="PLG_CONTENT_SWSEO_TITLE_LABEL"/></fieldset></fields></form>', false);
            break;
        }

        return true;
    }

    public function onContentBeforeDisplay($context, $article, $params, $limitstart){
        if($this->app->isClient('site')){
            switch($context){
                case 'com_content.category':
                case 'com_content.categories':
                    $title = $article->params->get('category_page_title', '');
                    if(!empty($title)){
                        $this->app->getDocument()->setTitle($title);
                    }
                break;
            }
        }
    }
}
