<?php   
// No direct access
defined( '_JEXEC' ) or die;

use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;

/**
 *
 * @package     Joomla.Plugin
 * @subpackage  System.SwSeo
 * @since       4.0+
 * @author		Sivers
 */
class plgContentSwseo extends CMSPlugin
{
    protected $app;

	public function __construct(&$subject, $config){
		parent::__construct($subject, $config);
        $this->loadLanguage();
		$this->app = Factory::getApplication();
    }
    
    public function onAfterInitialise(){
        if($this->app->isClient('site')){
        }
    }
    
	public function onContentPrepareForm($form, $data) {
        if (!($form instanceof Joomla\CMS\Form\Form)) {
            return false;
        }

        $name = $form->getName();

        if(
            (int)$this->params->get('article_title') && $name =='com_content.article'
            || (int)$this->params->get('category_title') && strpos($name, 'com_categories.category') === 0
        ){
            $this->app->getDocument()->addScriptDeclaration("
        document.addEventListener('DOMContentLoaded', function() {
            let wrapper = document.querySelector('#fieldset-metadata > div');
            let target = wrapper.querySelector('#jform_metadesc').closest('.control-group');
            wrapper.querySelectorAll('#jform_metadata_title').forEach(el => {
                wrapper.moveBefore(el.closest('.control-group'), target);
            });
        });
    ");
            $form->load('<?xml version="1.0" encoding="UTF-8"?><form><fields name="metadata"><fieldset name="basic"><field name="title" type="text" label="PLG_CONTENT_SWSEO_TITLE_LABEL"/></fieldset></fields></form>', false);
        }

        return true;
    }

    public function onContentBeforeDisplay($context, $article, $params, $limitstart){
        if($this->app->isClient('site')){
            if(
                (int)$this->params->get('article_title') && $context == 'com_content.article'
                || (int)$this->params->get('category_title') && $context == 'com_content.category'
            ){
                $title = $article->metadata->get('title', '');
                if(!empty($title)) $this->app->getDocument()->setTitle($title);
            }
        }
    }
}
