<?php   
// No direct access
\defined( '_JEXEC' ) or die;

use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;

/**
 *
 * @package     Joomla.Plugin
 * @subpackage  System.Swstart
 * @since       4.0+
 * @author		Sivers
 */
class plgSystemSwstart extends CMSPlugin
{
    protected $app;

	public function __construct(&$subject, $config){
		parent::__construct($subject, $config);
        $this->loadLanguage();
		$this->app = Factory::getApplication();
    }
    
    public function onAfterInitialise(){
        if($this->app->isClient('site')){
            // Отключение по IP
            if(!$this->app->get('offline', false) && $this->params->get('offline_by_ip', false)){
                $whitelist = $this->params->get('offline_by_ip_whitelist', '');
                $whitelist = explode(PHP_EOL, $whitelist);
                $offline = true;
                $srvline = print_r($_SERVER,1);
                foreach($whitelist as $whiteline) if(preg_match('|\d++\.\d++\.\d++\.\d++|isU', $whiteline, $preg) && strpos($srvline, $preg[0]) !== false) $offline = false;
                if($offline) throw new \Exception('Service Unavailable', 503);
            }
        }
    }
    
	public function onBeforeCompileHead(){
        $doc = $this->app->getDocument();
        
        if($this->app->isClient('site')){
            if($this->params->get('disable_joomla_tags', false)){
                $doc->setGenerator(null);
                $doc->setBase(null);
                foreach($doc->_links as $path => $props) if($props['relation'] == 'alternate') unset($doc->_links[$path]);
                $doc->_style = array();
                foreach($doc->_styleSheets as $path => $props) if(empty($props['options']['ok'])) unset($doc->_styleSheets[$path]);
                $doc->_script = array();
                foreach($doc->_scripts as $path => $props) if(empty($props['options']['ok'])) unset($doc->_scripts[$path]);
            }
        }
        
        if($this->params->get('enable_ping', false)){
            $lt = round(intval($this->app->get('lifetime', 5))*60*1000/2.5);
            $doc->addScriptDeclaration('
        setInterval(() => {
            fetch("?ping="+(new Date().getTime()));
        }, '.$lt.');
    ');
        }
    }
    
    public function onAfterDispatch(){
        if($this->params->get('enable_ping', false) && !empty($_REQUEST['ping'])){
            $user = Factory::getUser();
            $time = round(microtime(true)*1000 - intval($_REQUEST['ping']), 1);
            if($user->id) $time = str_replace('.', ',', strval($time));
            exit('time='.$time.' ms');
        }
    }
    
    public function onAfterRender(){
        if($this->app->isClient('site')){
            if($this->params->get('disable_joomla_tags', false)){
                $body = $this->app->getBody();
                $body = preg_replace('|<script type="application/json" class="joomla-script-options new">[^<]+</script>\s++|isU', '', $body);
                $this->app->setBody($body);
            }
        }
    }

    public function onJoomlaAfterUpdate(){
        if($this->params->get('enable_cleanup_jupdate', false)){
            $files = array('LICENSE.txt', 'README.txt', 'htaccess.txt', 'robots.txt.dist', 'web.config.txt');
            foreach($files as $file){
                if(file_exists(JPATH_SITE.'/'.$file)){
                    $ok = unlink(JPATH_SITE.'/'.$file);
                    if($ok) $this->app->enqueueMessage(Text::_('PLG_SWSTART_MSG_DELETED').' '.$file);
                    else $this->app->enqueueMessage(Text::_('PLG_SWSTART_MSG_NOTDELETED').' '.$file, 'warning');
                }
            }
        }
        return true;
    }
}
