<?php
/**
 * @package SW Cookie Agreement
 * @author SaWeb https://saweb.ru
 * @copyright Copyright (c) 2015 - 2025 SaWeb
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or Later
*/

defined ('_JEXEC') or die();

use Joomla\CMS\Factory;
use Joomla\CMS\Plugin\CMSPlugin;

class PlgSystemSwcookie extends CMSPlugin
{

	public function onAfterRender() {

        $app = Factory::getApplication();
	
		if ($app->isClient('administrator'))
        {
			return;
		}

		if($app->input->cookie->get('swcookie_status', '') != 'ok')
		{
			$cookie_content = $this->params->get('cookie_content', '');
			$cookie_content_class = $this->params->get('cookie_content_class', '');
			$button_text = $this->params->get('button_text', '');
			$button_class = $this->params->get('button_class', 'btn btn-primary');

            $html = '<div>'.trim($cookie_content).'</div>';
            $html = str_replace('{a}', '<a href="/plugins/system/swcookie/assets/doc/cookies-agreement.pdf" target="_blank">', $html);
            $html = str_replace('{/a}', '</a>', $html);
            $btn = '';
            if(!empty($button_text)) $btn .= '<button type="button" class="'.$button_class.'" onclick="onClickSwCookieAgreement(this);">'.$button_text.'</button>';
            if(!empty($cookie_content_class)) $html = '<div class="'.$cookie_content_class.'">'.$html.$btn.'</div>';

            $head = '';
            if(file_exists(__DIR__ .'/assets/css/style.css')) $head .= '<style type="text/css">'.file_get_contents(__DIR__ .'/assets/css/style.css').'</style>';
            if(file_exists(__DIR__ .'/assets/js/script.js')) $head .= '<script>'.file_get_contents(__DIR__ .'/assets/js/script.js').'</script>';

            $body = $app->getBody();
            $body = str_replace('</head>', $head.'</head>', $body);
            $body = str_replace('</body>', $html.'</body>', $body);
            $app->setBody($body);
		}
	}
}
